package zeropage.org.wikinote.Util;

import android.net.Uri;

import com.android.volley.AuthFailureError;
import com.android.volley.Response;
import com.android.volley.toolbox.StringRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by CAUCSE on 2015-10-13.
 */
public class PostStringRequest extends StringRequest{
    private final String[] formDataKey;
    private final String[] formDataValue;

    public PostStringRequest(String url, Response.Listener<String> responseListener, Response.ErrorListener errorListener, WikinotePostable postCommand) {
        super(Method.POST, url, responseListener, errorListener);
        this.formDataKey = postCommand.getFormDataKey();
        this.formDataValue = postCommand.getFormDataValue();
    }

    @Override
    protected Map<String,String> getParams(){
        Map<String,String> params = new HashMap<String, String>();

        for (int i = 0; i < this.formDataKey.length; i++) {
            params.put(this.formDataKey[i], this.formDataValue[i]);
        }
        return params;
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        Map<String,String> params = new HashMap<String, String>();
        params.put("Content-Type","application/x-www-form-urlencoded");
        return params;
    }
}
