package zeropage.org.wikinote.SQL;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
//import zeropage.org.wikinote.MySQLiteOpenHelper;

/**
 * Created by user on 2015-10-29.
 */
public class SynchronizedSQL extends SQLiteOpenHelper implements DBcommand {
    private SQLiteDatabase db;
    public SynchronizedSQL(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        db = this.getWritableDatabase();
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        String sql = "create table Synchronized(" +
                "no integer primary key autoincrement, " +
                "title text + " +
                "up_title text" +
                "context text);";
        db.execSQL(sql);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        String sql = "drop table if exists no";
        db.execSQL(sql);
        onCreate(db);
    }

    public void insert(String title, String upTitle, String context){
        String sql = "insert into Synchronized(title, up_title, context) values (" +
                title + ", " +
                upTitle + ", " +
                context + ");";
        insert(sql);
    }

    @Override
    public void insert(String command) {
        db.execSQL(command);
    }

    public void overwrite(int no, String type, String newInfo){
        String sql = "update Synchronized set " +
                type + " = " + newInfo + "where " +
                "no = " + no;
        overwrite((sql));
    }

    @Override
    public void overwrite(String command) {
        db.execSQL(command);
    }

    public void delete(int num){
        String sql = "delete from Synchronized where" +
                "no = " + num;
        delete(sql);
    }
    @Override
    public void delete(String command) {
        db.execSQL(command);
    }

    @Override
    public int select(String title, String data){
        Cursor c = db.query("Synchronized", null, null, null, null, null, null);
        String output;
        int ret = -1;
        while(c.moveToNext()){
            output = c.getString(c.getColumnIndex(title));
            if(output.equals(data)){
                ret = c.getInt((c.getColumnIndex("no")));
                break;
            }
        }
        return ret;
    }
}
