package zeropage.org.wikinote.Network;

import android.util.Log;

import com.android.volley.Response;
import com.android.volley.VolleyError;

import zeropage.org.wikinote.Util.PostStringRequest;
import zeropage.org.wikinote.Util.WikinotePostable;
import zeropage.org.wikinote.Util.WikinoteUrlFactory;

/**
 * Created by Lumin on 2015-10-13.
 */
public class WikinoteHttpPOST {
    private static final String ERROR_MESSAGE = "Http POST Failed.";

    /** Prevent from creating object.*/
    private WikinoteHttpPOST() {

    }
    public static PostStringRequest getPostStringRequest(String userName, String memoPath, Response.Listener<String> responseListenerToUse, Response.ErrorListener errorListenerToUse, WikinotePostable postCommand) {
        final WikinoteUrlFactory url = new WikinoteUrlFactory(userName, postCommand.getFormDataPageName(), memoPath);
        Log.e("TEST", url.getWikinoteUrl());
        PostStringRequest stringRequestToReturn = new PostStringRequest(url.getWikinoteUrl(), responseListenerToUse, errorListenerToUse, postCommand);
        return stringRequestToReturn;
    }

    public static PostStringRequest getPostStringRequest(String userName, String memoPath, Response.Listener<String> responseListenerToUse, WikinotePostable postCommand) {
        return getPostStringRequest(userName, memoPath, responseListenerToUse, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                Log.e("HTTP Post", "Post Error : " + error.getMessage());
            }
        }, postCommand);
    }
}
