package zeropage.org.wikinote.Network;

import android.accounts.Account;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;

import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Scopes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.plus.Plus;
import java.io.IOException;

/**
 * Created by Lumin on 2015-10-29.
 */
public class WikinoteGoogleApiClient implements GoogleApiClient.ConnectionCallbacks, GoogleApiClient.OnConnectionFailedListener {
    private static final String LOG_TAG = "GoogleSignIn";
    private static final String EMPTY = "";
    private static WikinoteGoogleApiClient instance;
    private GoogleApiClient googleApiClient;
    private Activity apiClientActivity;
    private SharedPreferences prefs;
    private boolean isResolving;
    private boolean shouldResolve;


    private WikinoteGoogleApiClient(Activity activityToUse) {
        this.apiClientActivity = activityToUse;
        this.prefs = PreferenceManager.getDefaultSharedPreferences(apiClientActivity.getApplicationContext());
    }

    private void setMemberToNull() {
        this.prefs.edit().putString("userToken", EMPTY).apply();
        this.googleApiClient = null;
        this.apiClientActivity = null;
    }

    private void checkApiClientBuilt() throws IllegalAccessError {
        if (this.googleApiClient == null) {
            throw new IllegalAccessError("Please invoke buildApiClient method first!");
        }
    }

    public static synchronized WikinoteGoogleApiClient getInstance(Context contextToUse) {
        if (instance == null) {
            instance = new WikinoteGoogleApiClient((Activity) contextToUse);
        }

        return instance;
    }

    @Override
    public void onConnected(Bundle bundle) {
        Log.e(LOG_TAG, "onConnected:" + bundle);
        shouldResolve = false;
        Log.e(LOG_TAG, "Token : " + WikinoteGoogleApiClient.getInstance(apiClientActivity).getToken());
    }

    @Override
    public void onConnectionSuspended(int i) {
        Log.e(LOG_TAG, "onConnectionSuspended : " + i);
    }

    @Override
    public void onConnectionFailed(ConnectionResult connectionResult) {
        // Could not connect to Google Play Services.  The user needs to select an account,
        // grant permissions or resolve an error in order to sign in. Refer to the javadoc for
        // ConnectionResult to see possible error codes.
        Log.d(LOG_TAG, "onConnectionFailed:" + connectionResult);

        if (!this.isResolving && this.shouldResolve) {
            if (connectionResult.hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(apiClientActivity, 0);
                    isResolving = true;
                } catch (IntentSender.SendIntentException e) {
                    Log.e(LOG_TAG, "Could not resolve ConnectionResult.", e);
                    isResolving = false;
                    this.setConnecting(true);
                }
            } else {
                Log.e(LOG_TAG, "Connection Error : " + connectionResult);
            }
        } else {

        }
    }

    public void buildGoogleApiClient() throws IllegalAccessError{
        if (this.apiClientActivity == null) {
            throw new IllegalAccessError("You didn't put your activity first.");
        }

        this.googleApiClient = new GoogleApiClient.Builder(this.apiClientActivity)
                .addConnectionCallbacks(this)
                .addOnConnectionFailedListener(this)
                .addApi(Plus.API)
                .addScope(new Scope(Scopes.EMAIL))
                .addScope(new Scope(Scopes.PROFILE))
                .build();
    }

    public void setConnecting(boolean shouldConnecting) throws IllegalAccessError {
        this.checkApiClientBuilt();
        GoogleConnectTask connectTask = new GoogleConnectTask();
        connectTask.execute(shouldConnecting);
    }

    public boolean isClientConnected() throws IllegalAccessError {
        this.checkApiClientBuilt();
        return this.googleApiClient.isConnected();
    }

    public boolean isClientConnecting() throws IllegalAccessError {
        this.checkApiClientBuilt();
        return this.googleApiClient.isConnecting();
    }

    public void setClientAppDisconnected() throws IllegalAccessError {
        this.checkApiClientBuilt();
        if (this.googleApiClient.isConnected()) {
            Plus.AccountApi.clearDefaultAccount(this.googleApiClient);
            Plus.AccountApi.revokeAccessAndDisconnect(this.googleApiClient);
            this.googleApiClient.disconnect();
            this.setMemberToNull();
        } else {
            throw new IllegalAccessError("Client seems not to be connected.");
        }
    }

    public String getPersonEmail() throws IllegalAccessError {
        this.checkApiClientBuilt();
        return Plus.AccountApi.getAccountName(this.googleApiClient);
    }

    public String getToken() throws IllegalAccessError {
        this.checkApiClientBuilt();
        String userToken = prefs.getString("userToken", EMPTY);

        if (!googleApiClient.isConnected()) {
            return EMPTY;
        }

        if (userToken.equals(EMPTY)) {
            TokenGetter tokenGetter = new TokenGetter();
            tokenGetter.execute();
        }

        return userToken;
    }

    public boolean isResolving() {
        return isResolving;
    }

    public void setIsResolving(boolean isResolving) {
        this.isResolving = isResolving;
    }

    public boolean isShouldResolve() {
        return shouldResolve;
    }

    public void setShouldResolve(boolean shouldResolve) {
        this.shouldResolve = shouldResolve;
    }

    private class TokenGetter extends AsyncTask<Void, Void, String> {
        private static final String DIALOG_MSG = "필요한 정보를 받아오는 중입니다...";
        private ProgressDialog asyncProgressDialog;
        private String userIdToken = EMPTY;

        @Override
        protected void onPreExecute() {
            this.asyncProgressDialog = ProgressDialog.show(apiClientActivity, EMPTY, DIALOG_MSG, false, false);
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Void... voids) {
            try {
                String accountName = getPersonEmail();
                Account account = new Account(accountName, GoogleAuthUtil.GOOGLE_ACCOUNT_TYPE);
                String scopes = "oauth2:" + Scopes.PLUS_LOGIN + " " + Scopes.PROFILE;
                String token = GoogleAuthUtil.getToken(apiClientActivity, account, scopes);
                prefs.edit().putString("userToken", token).apply();
            } catch (UserRecoverableAuthException e) {
                apiClientActivity.startActivityForResult(e.getIntent(), 0);
            } catch (IOException | GoogleAuthException e) {
                Log.e(LOG_TAG, "Error retrieving ID token.", e);
            }

            return EMPTY;
        }

        @Override
        protected void onPostExecute(String result) {
            this.asyncProgressDialog.dismiss();
        }
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    private class GoogleConnectTask extends AsyncTask<Boolean, Void, Void> {
        private static final String DIALOG_MSG = "Logging in....";

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected Void doInBackground(Boolean... params) {
            if (params[params.length - 1]) {
                googleApiClient.connect();
            } else {
                googleApiClient.disconnect();
            }

            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
        }
    }
}