package zeropage.org.wikinote.Activity;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;

import com.android.volley.Response;

import zeropage.org.wikinote.Editor.HighlightingEditor;
import zeropage.org.wikinote.Model.Constants;
import zeropage.org.wikinote.Network.WikinoteQueue;
import zeropage.org.wikinote.R;
import zeropage.org.wikinote.Util.WikinoteEditParam;

/**
 * Created by SH on 2015-11-22.
 */
public class EditActivity extends AppCompatActivity{

    public static final String EMPTY_STRING = "";

    private EditText noteTitle;
    private HighlightingEditor content;
    private ScrollView scrollView;
    private ViewGroup keyboardBarView;

    private String title;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit);
        //add components
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        Button button = (Button)findViewById(R.id.sendPost);
        final EditText editToolBar = (EditText)findViewById(R.id.edit_note_title);
        content = (HighlightingEditor)findViewById(R.id.editor);
        scrollView = (ScrollView) findViewById(R.id.note_scrollview);
        keyboardBarView = (ViewGroup) findViewById(R.id.keyboard_bar);

        //get strings from MainActivity.java
        final Intent moveToMain = getIntent();
        if (toolbar != null) {
            setSupportActionBar(toolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        //add here
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                EditText toolbar = (EditText) findViewById(R.id.edit_note_title);
                String temp = moveToMain.getStringExtra("title");
                Log.e("mentoring", "Title : " + temp);
                toolbar.setText(temp);

                content.setText((moveToMain.getStringExtra("contents")));
            }
        }, 100);

        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //add here
                title = editToolBar.getText().toString();
                WikinoteQueue.getInstance(getApplicationContext()).sendHttpPostRequestToWikinote("dev", title, new Response.Listener(){
                    @Override
                    public void onResponse(Object response) {
                        Log.e("testest", response.toString());
                    }
                }, new WikinoteEditParam(content.getText().toString()));

                startActivity(moveToMain);
            }
        });
        //toolbar.setOnClickListener(postText);

    }

    @Override
    protected void onResume() {
        // Set up the font and background activity_preferences
        setupKeyboardBar();
        //setupAppearancePreferences();

        super.onResume();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    private void setupKeyboardBar() {
        //boolean showShortcuts = PreferenceManager.getDefaultSharedPreferences(this).getBoolean(getString(R.string.pref_show_markdown_shortcuts_key), true);
        boolean showShortcuts = true;

        if (showShortcuts && keyboardBarView.getChildCount() == 0) {
            appendRegularShortcuts();
            if(isSmartShortcutsActivated()) {
                appendSmartBracketShortcuts();
            } else {
                appendRegularBracketShortcuts();
            }
        } else if (!showShortcuts) {
            findViewById(R.id.keyboard_bar_scroll).setVisibility(View.GONE);
        }
    }

    private void appendRegularShortcuts() {
        for (String shortcut : Constants.KEYBOARD_SHORTCUTS) {
            appendButton(shortcut, new KeyboardBarListener());
        }
    }

    private void appendRegularBracketShortcuts() {
        for (String shortcut : Constants.KEYBOARD_SHORTCUTS_BRACKETS) {
            appendButton(shortcut, new KeyboardBarListener());
        }
    }

    private void appendSmartBracketShortcuts() {
        for (String shortcut : Constants.KEYBOARD_SMART_SHORTCUTS) {
            appendButton(shortcut, new KeyboardBarSmartShortCutListener());
        }
    }

    private void appendButton(String shortcut, View.OnClickListener l) {
        TextView shortcutButton = (TextView) getLayoutInflater().inflate(R.layout.keyboard_shortcut, null);
        shortcutButton.setText(shortcut);
        shortcutButton.setOnClickListener(l);

        shortcutButton.setTextColor(getResources().getColor(android.R.color.black));

        keyboardBarView.addView(shortcutButton);
    }

    private boolean isSmartShortcutsActivated() {
        return true;
        //return PreferenceManager.getDefaultSharedPreferences(context).getBoolean(getString(R.string.pref_smart_shortcuts_key),false);
    }

    /**
     * Called when a view has been clicked.
     *
     */


    private class KeyboardBarListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            CharSequence shortcut = ((TextView) v).getText();
            content.getText().insert(content.getSelectionStart(), shortcut);
        }
    }

    private class KeyboardBarSmartShortCutListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            CharSequence shortcut = ((TextView) v).getText();
            if(content.hasSelection()) {
                CharSequence selected = content.getText().subSequence(content.getSelectionStart(),
                        content.getSelectionEnd());

                if( shortcut.charAt(0) == '@' ){
                    content.getText().replace(content.getSelectionStart(), content.getSelectionEnd(),
                            "["+selected+"](wikinote://current/Path)");
                } else {
                    content.getText().replace(content.getSelectionStart(), content.getSelectionEnd(),
                            Character.toString(shortcut.charAt(0)) + selected + shortcut.charAt(1));
                }

            } else {
                content.getText().insert(content.getSelectionStart(), shortcut);
                content.setSelection(content.getSelectionStart() - 1);
            }
        }
    }

}
