package zeropage.org.wikinote.SQL;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

/**
 * Created by user on 2015-10-29.
 */
public class SynchronizeeSQL extends SQLiteOpenHelper implements DBcommand {
    private SQLiteDatabase db;
    public SynchronizeeSQL(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        String sql = "create table Synchronizee(" +
                "ID integer primary key, " +
                "title text" +
                "up_title text" +
                "context text " +
                "foreign key ID references Synchronized " +
                "on delete cascade);";
        db.execSQL(sql);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        String sql = "drop table if exists ID";
        db.execSQL(sql);
        onCreate(db);
    }

    public void insert(int num, String title, String upTitle, String context){
        String sql = "insert into Synchronized values (" +
                num + ", " +
                title + ", " +
                upTitle + ", " +
                context + ");";
        insert(sql);
    }

    @Override
    public void insert(String command) {
        db.execSQL(command);
    }

    public void overwrite(int no, String title, String upTitle, String type, String newInfo){
        String sql = "update Synchronized set " +
                type + " = " + newInfo + "where " +
                "no = " + no;
        //한꺼번에 title 변경이 가능한가? 이거 확인해줬으면 좋겠군.
        overwrite((sql));
    }

    @Override
    public void overwrite(String command) {
        db.execSQL(command);
    }

    public void delete(int num){
        String sql = "delete from Synchronized where" +
                "no = " + num;
        delete(sql);
    }
    @Override
    public void delete(String command) {
        db.execSQL(command);
    }

    @Override
    public int select(String title, String data) {
        int ret = -1;
        String output;
        Cursor c = db.query("Synchronizee", null, null, null, null, null, null);
        while(c.moveToNext()){
            output = c.getString(c.getColumnIndex(title));
            if(output.equals(data)) {
                ret = c.getInt(c.getColumnIndex("no"));
                break;
            }
        }
        return ret;
    }
}
