package zeropage.org.wikinote.Network;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import zeropage.org.wikinote.Util.WikinotePostable;

/**
 * Created by Lumin on 2015-10-10.
 */

/**
 *  Singleton Class. To use this class instance, you should invoke getInstance() method.
 *  If you send HTTP request to Wikinote server, you can invoke sendHttp~ methods.
 */
public class WikinoteQueue {
    private static WikinoteQueue volleyInstance;
    private static RequestQueue requestQueueInstance;
    private static Context queueContext;

    private WikinoteQueue(Context contextToUse) {
        queueContext = contextToUse;
        requestQueueInstance = this.getRequestQueueInstance();
    }

    public static synchronized WikinoteQueue getInstance(Context contextToUse) {
        if (volleyInstance == null) {
            volleyInstance = new WikinoteQueue(contextToUse);
        }

        return volleyInstance;
    }

    public RequestQueue getRequestQueueInstance() {
        if (requestQueueInstance == null) {
            requestQueueInstance = Volley.newRequestQueue(queueContext.getApplicationContext());
        }
        return requestQueueInstance;
    }

    public void sendHttpGetRequestToWikinote(String userName, String memoPathName, Response.Listener listener) {
        StringRequest requestObject = WikinoteHttpGET.getStringRequest(userName, memoPathName, listener);
        this.addObjectToRequestQueue(requestObject);
    }

    public void sendHttpGetRequestToWikinote(String userName, String memoPathName, Response.Listener listener, Response.ErrorListener errorListener) {
        StringRequest requestObject = WikinoteHttpGET.getStringRequest(userName, memoPathName, listener, errorListener);
        this.addObjectToRequestQueue(requestObject);
    }

    public void sendHttpPostRequestToWikinote(String userName, String memoPathName, Response.Listener listener, WikinotePostable postObject)
    {
        StringRequest requestObject = WikinoteHttpPOST.getPostStringRequest(userName, memoPathName, listener, postObject);
        this.addObjectToRequestQueue(requestObject);
    }

    public void sendHttpPostRequestToWikinote(String userName, String memoPathName, Response.Listener listener, Response.ErrorListener errorListener, WikinotePostable postObject)
    {
        StringRequest requestObject = WikinoteHttpPOST.getPostStringRequest(userName, memoPathName, listener, errorListener, postObject);
        this.addObjectToRequestQueue(requestObject);
    }

    public <T> void addObjectToRequestQueue(Request<T> requestToAdd) {
        this.getRequestQueueInstance().add(requestToAdd);
    }
}