package zeropage.org.wikinote.Network;

import android.util.Log;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import org.json.JSONObject;

import java.util.Map;

import zeropage.org.wikinote.Util.WikinoteUrlFactory;

/**
 * Created by Lumin on 2015-10-13.
 */
public class WikinoteHttpGET {
    private static final String ERROR_MESSAGE = "HTTP GET failed.";

    /** Prevent from creating object.*/
    private WikinoteHttpGET() {

    }

    public static StringRequest getStringRequest(String userName, String memoPath, Response.Listener<String> responseListenerToUse, Response.ErrorListener errorListenerToUse) {
        WikinoteUrlFactory url = new WikinoteUrlFactory(userName, memoPath);
        StringRequest stringRequestToReturn = new StringRequest(Request.Method.GET, url.getWikinoteUrl(), responseListenerToUse, errorListenerToUse);
        return stringRequestToReturn;
    }

    public static StringRequest getStringRequest(String userName, String memoPath, Response.Listener<String> responseListenerToUse) {
        return getStringRequest(userName, memoPath, responseListenerToUse, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                Log.e("HTTP Get", "GET Error : " + error.getMessage());
            }
        });
    }

    public static JsonObjectRequest getJsonObjectRequest(String userName, String memoPath, Map<String, String> keyValuePairMap, Response.Listener<JSONObject> responseListenerToUse, Response.ErrorListener errorListenerToUse) {
        WikinoteUrlFactory url = new WikinoteUrlFactory(userName, memoPath);
        JSONObject jsonObjectToRequest = new JSONObject(keyValuePairMap);
        JsonObjectRequest jsonObjectRequestToReturn = new JsonObjectRequest(Request.Method.GET, url.getWikinoteUrl(), jsonObjectToRequest, responseListenerToUse, errorListenerToUse);
        return jsonObjectRequestToReturn;
    }
}
