package zeropage.org.wikinote.Activity;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.commonsware.cwac.anddown.AndDown;

import java.io.File;

import zeropage.org.wikinote.R;

/**
 * Created by SH on 2015-11-22.
 */
public class ReadActivity extends AppCompatActivity {

    private WebView contentView;
    private String mdRaw;
    private String mdHtml;

    private AndDown renderer = new AndDown();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_read);

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        contentView = (WebView) findViewById(R.id.md_webview);

        if (toolbar != null) {
            setSupportActionBar(toolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }

        // Protocol 분석
        Intent intent = getIntent();
        if(intent.ACTION_VIEW.equals(intent.getAction())){
            Uri uri = intent.getData();
            mdRaw = uri.getQueryParameter("path");
        }

        mdRaw = "#Text \n [Visit GitHub!](https://www.github.com) \n [Wikinote!](wikinote://www.github.com)";
        mdHtml = renderer.markdownToHtml(mdRaw);

        contentView.loadDataWithBaseURL("", mdHtml, "text/html", "UTF-8", null);

        contentView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("wikinote://")) {
                    String temp ="wikinote://read?path=FrontPage";
                    Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(temp));
                    startActivity(i);
                    return true;
                }
                return false;
            }
        });

    }

}
