package zeropage.org.wikinote;

import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by SH on 2015-10-15.
 */
public class APKdownAsyncTask extends AsyncTask<String,Void,Boolean> {

    private PostExecuteListener listener;

    public void setOnPostExecuteListener(PostExecuteListener l){
        listener = l;
    }

    @Override
    protected void onPostExecute(Boolean result) {
        if( result ) this.listener.success();
        else this.listener.error();
    }

    @Override
    protected Boolean doInBackground(String... arg0) {

        if( listener == null ) {
            Log.e("APKdownTread", "You must set listener before AsyncTask run" );
            return false;
        }

        try {
            URL url = new URL(arg0[0]);
            HttpURLConnection c = (HttpURLConnection) url.openConnection();
            c.setRequestMethod("GET");
            c.setDoOutput(true);
            c.connect();

            String PATH = "/mnt/sdcard/Download/";
            File file = new File(PATH); file.mkdirs();
            File outputFile = new File(file, "DexTest.apk");
            if(outputFile.exists()){ Log.i("file", "File already Exist"); return false; }

            FileOutputStream fos = new FileOutputStream(outputFile);

            InputStream is = c.getInputStream();

            byte[] buffer = new byte[1024];
            int len1 = 0;
            while ((len1 = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len1);
            }
            fos.close();
            is.close();

            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setDataAndType(Uri.fromFile(new File("/mnt/sdcard/Download/DexTest.apk")), "application/vnd.android.package-archive");
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK); // without this flag android returned a intent error!

            return true;

        } catch (Exception e) {
            Log.e("APKdown", "Error!");
        }

        return false;
    }

}
